% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcat.R
\name{is.fcat}
\alias{is.fcat}
\title{Class test for a format catalog}
\usage{
is.fcat(x)
}
\arguments{
\item{x}{The object to test.}
}
\value{
TRUE or FALSE, depending on whether or not the object is a 
format catalog.
}
\description{
This function tests whether an object is a format catalog.  The
format catalog has a class of "fcat".
}
\examples{
# Create format catalog
c1 <- fcat(num_fmt  = "\%.1f",
           label_fmt = value(condition(x == "A", "Label A"),
                             condition(x == "B", "Label B"),
                             condition(TRUE, "Other")),
           date_fmt = "\%d\%b\%Y")
           
# Test for "fcat" class
is.fcat(c1)  
is.fcat(Sys.Date())          
}
\seealso{
Other fcat: 
\code{\link{as.data.frame.fcat}()},
\code{\link{as.fcat.data.frame}()},
\code{\link{as.fcat.fmt_lst}()},
\code{\link{as.fcat.list}()},
\code{\link{as.fcat}()},
\code{\link{fcat}()},
\code{\link{print.fcat}()},
\code{\link{read.fcat}()},
\code{\link{write.fcat}()}
}
\concept{fcat}
