% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpmf.R
\name{mpmf}
\alias{mpmf}
\title{fit the move persistence model to regularized location data}
\usage{
mpmf(
  x,
  model = c("jmpm", "mpm"),
  control = mpm_control(),
  inner.control = NULL
)
}
\arguments{
\item{x}{temporally regularized location data, eg. output from \code{fit_ssm}}

\item{model}{specify whether MPM is to be fit with unpooled ("mpm") or pooled ("jmpm") RW variance(s).}

\item{control}{list of control settings for the outer optimizer (see \code{mpm_control} for details)}

\item{inner.control}{list of control settings for the inner optimization
(see ?TMB::MakeADFUN for additional details)}

\item{verbose}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} use ssm_control(verbose = 1) instead, see \code{ssm_control} for details}

\item{optim}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} use ssm_control(optim = "optim") instead, see \code{ssm_control} for details}

\item{optMeth}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} use ssm_control(method = "L-BFGS-B") instead, see \code{ssm_control} for details}
}
\description{
generates initial values for model parameters and unobserved gamma's;
structures data and initial values for C++ \code{TMB} template;
fits move persistence model; minimizes the joint log-likelihood via the selected
optimizer (\code{nlminb} or \code{optim}); structures and passes output
object to \code{fit_mpm}
}
\details{
called by \code{fit_mpm}, not intended for general use. see ?fit_mpm.
}
\keyword{internal}
