% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_i.R
\name{fa_i}
\alias{fa_i}
\title{Generate a Font Awesome \verb{<i>} tag}
\usage{
fa_i(
  name,
  class = NULL,
  ...,
  prefer_type = c("regular", "solid"),
  html_dependency = fa_html_dependency()
)
}
\arguments{
\item{name}{The name of the Font Awesome icon. This could be as a short name
(e.g., \code{"npm"}, \code{"drum"}, etc.), or, a full name (e.g., \code{"fab fa-npm"},
\code{"fas fa-drum"}, etc.). The names should correspond to current Font Awesome
names. A list of short and full names can be accessed through the
\code{\link[=fa_metadata]{fa_metadata()}} function with \code{fa_metadata()$icon_names} and
\code{fa_metadata()$icon_names_full}. If supplying a known alias to a short icon
name (e.g., \code{"vcard"}, which is now \code{"address-card"}), it will be
internally translated to the current icon name before returning the icon
tag.}

\item{class}{Additional classes to customize the style of the icon.}

\item{...}{Arguments passed to the \verb{<i>} tag of \link[htmltools:builder]{htmltools::tags}.}

\item{prefer_type}{Chooses the type of icon returned if: (1) providing a
short name, and (2) that icon has both solid and regular types.
For example, using \code{name = "address-book"} will result in two types of
icons for an Address Book. By default, this preference is set to
\code{"regular"} and the other option is \code{"solid"}.}

\item{html_dependency}{Provides an opportunity to use a custom
\code{html_dependency} object (created via a call to
\code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}}) instead of one supplied by the function
(which uses Font Awesome's free assets and are bundled in the package). A
custom \code{html_dependency} object is useful when you have paid icons from
Font Awesome or would otherwise like to customize exactly which icon assets
are used (e.g., \code{woff}, \code{woff2}, \code{eot}, etc.). By default, this is \code{NULL}
where the function internally generates an \code{html_dependency}.}
}
\value{
An icon element.
}
\description{
The \code{fa_i()} function creates a Font Awesome \verb{<i>} tag and not an SVG as with
\code{\link[=fa]{fa()}}. The primary use case for \code{fa_i()} is for legacy Shiny applications
that use the \code{shiny::icon()} function. This function is called within a
\code{shiny::icon()} call and all HTML dependencies to support icon generation are
hosted in the \strong{fontawesome} package.
}
\examples{
if (interactive()) {

# Create a Font Awesome icon object
fa_i(name = "r-project")

}

}
