% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_graph.R
\name{save_graph}
\alias{save_graph}
\title{Save graph}
\usage{
save_graph(graph, filename = "foodingraph_\%03d.png", width = NULL,
  height = NULL, dpi = 300, ...)
}
\arguments{
\item{graph}{: the graph}

\item{filename}{(optional) : the name of the file and format.
Default is "foodingraph_*.png".}

\item{width}{(optional) : width of the image in cm. Default is 25 cm
for a single graph or a comparison in a vertical position.
For a comparison in an horizontal position, 40cm.}

\item{height}{(optional) : height of the image in cm. Default is 20 cm
for a single graph, 25cm for a comparison in an horizontal position.
For a comparison in a vertical position, 40cm.}

\item{dpi}{(optional) : the resolution of the image in dpi. Default is 300}

\item{...}{: other parameters to pass to the \code{ggsave} ggplot2 function}
}
\description{
Save the graph generated from \code{\link{graph_from_matrix}}
or \code{\link{graph_from_links_nodes}} or
\code{\link{compare_graphs}}.
}
\examples{
adj_matrix <- cor(iris[,-5])
legend <- data.frame(name = colnames(iris[,-5]),
                     title = colnames(iris[,-5]))
graph_iris <- graph_from_matrix(adj_matrix, legend, main_title = "Iris graph")

# Save to a in a temporary file location
save_graph(graph_iris, tempfile(fileext = ".png"))
}
