% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foot_round_robin.R
\name{foot_round_robin}
\alias{foot_round_robin}
\title{Round-robin for football leagues}
\usage{
foot_round_robin(object, data, teams = NULL)
}
\arguments{
\item{object}{An object of class \code{\link[rstan]{stanfit}} or \code{stanFoot} as given by \code{stan_foot} function.}

\item{data}{A data frame containing match data with columns:
\itemize{
  \item \code{periods}:  Time point of each observation (integer >= 1).
  \item \code{home_team}: Home team's name (character string).
  \item \code{away_team}: Away team's name (character string).
  \item \code{home_goals}: Goals scored by the home team (integer >= 0).
  \item \code{away_goals}: Goals scored by the away team (integer >= 0).
}}

\item{teams}{An optional character vector specifying team names to include. If \code{NULL}, all teams are included.}
}
\value{
Round-robin plot with the home-win posterior probabilities computed from the ppd of the fitted model via the \code{stan_foot} function.
}
\description{
Posterior predictive probabilities for a football season in a round-robin format
}
\details{
For Bayesian models fitted via \code{stan_foot} the round-robin table is computed according to the
simulation from the posterior predictive distribution of future (out-of-sample) matches.
The dataset should refer to one or more seasons from a given national football league (Premier League, Serie A, La Liga, etc.).
}
\examples{

\dontrun{
library(dplyr)

data("italy")
italy_1999_2000<- italy \%>\%
dplyr::select(Season, home, visitor, hgoal,vgoal) \%>\%
dplyr::filter(Season == "1999"|Season=="2000")

colnames(italy_1999_2000) <- c("periods", "home_team", "away_team", "home_goals", "away_goals")

fit <- stan_foot(italy_1999_2000, "double_pois", predict = 45, iter = 200)

foot_round_robin(fit, italy_1999_2000)
foot_round_robin(fit, italy_1999_2000, c("Parma AC", "AS Roma"))

}
}
\author{
Leonardo Egidi \email{legidi@units.it}
}
