% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ofp.R
\name{ofp}
\alias{ofp}
\title{Calculate ozone formation potential}
\usage{
ofp(
  df,
  inunit = "ppbv",
  outunit = "ppbv",
  t = 25,
  p = 101.325,
  stcd = FALSE,
  sortd = TRUE,
  colid = 1,
  chn = FALSE
)
}
\arguments{
\item{df}{dataframe contains time series.}

\item{inunit}{input's unit for VOC concentration. A character vector from these options: "ugm" or "ppbv". 
"ugm" means ug/m3. "ppbv" means part per billion volumn. The default vaule is "ppbv".}

\item{outunit}{output's unit for VOC concentration. A character from these options: "ugm" or "ppbv". 
"ugm" means ug/m3. "ppbv" means part per billion volumn. The default vaule is "ppbv".}

\item{t}{Temperature, in Degrees Celsius, used to convert data in 
micrograms per cubic meter to standard conditions 
(25 Degrees Celsius, 101.325 kPa). By default, t equals to 25 Degrees Celsius.}

\item{p}{Pressure, in kPa, used to convert data in micrograms per cubic meter 
to standard conditions (25 Degrees Celsius, 101.325 kPa). 
By default, p equals to 101.325 kPa.}

\item{stcd}{logical. Does it output results in standard conditions? The default vaule is FALSE.}

\item{sortd}{logical value. It determines whether the VOC species
are sorted or not. By default, sortd has value "TRUE".
If TRUE, VOC species in time series will be arranged according to VOC group,
 relative molecular weight, and MIR value.}

\item{colid}{column index for date-time. The default value is 1.}

\item{chn}{logical. Dose colnames present as Chinese? The default vaule is FALSE.}
}
\value{
a list contains 5 tables:
MIR_Result: matched MIR value result;
OFP_Result: OFP time series of VOC by species;
OFP_Result_mean: the average value and proportion of OFP of VOC by species (sorted from large to small);
OFP_Result_group: OFP time series of VOC classified by groups;
OFP_Result_group_mean: the average value and proportion of OFP of VOC according to major groups (sorted from large to small).
}
\description{
Calculate Ozone Formation Potential (OFP) of VOC time series.
Note: for Chinese VOC name, please also use English punctuation.
}
\details{
The CAS number is matched for each VOC speices (from column name), and the
Maximum Incremental Reactivity (MIR) value is matched through the CAS number and used for time series calculation. \cr
The MIR value comes from "Carter, W. P. (2009). Updated maximum incremental
reactivity scale and hydrocarbon bin reactivities for regulatory applications.
California Air Resources Board Contract, 2009, 339" (revised January 28, 2010).
Note: If input VOC species contain M,P-xylene, it will be automatically divided into m-xylene and P-xylene evenly.
}
\examples{
ofp(voc)
}
