% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ts-models-tvARMA}
\alias{ts-models-tvARMA}
\alias{tvARMA}
\title{Simulation of an tvARMA(p) time series.}
\usage{
tvARMA(T = 128, a = list(), b = list(), sigma = function(u) {    
  return(1) }, innov = function(n) {     rnorm(n, 0, 1) })
}
\arguments{
\item{T}{length of the time series to be returned}

\item{a}{list of p real-valued functions defined on \eqn{[0,1]}}

\item{b}{list of q real-valued functions defined on \eqn{[0,1]}}

\item{sigma}{function}

\item{innov}{a function with one argument \code{n} that simulates a vector of
the \code{n} residuals \eqn{\varepsilon_t}.}
}
\value{
Returns a tvARMA(p,q) time series with specified parameters.
}
\description{
Returns a simulated time series \eqn{Y_{1,T}, ..., Y_{T,T}} that fulfills
the following equation:
\deqn{Y_{t,T} = \sum_{j=1}^p a_j(t/T) Y_{t-j,T} + \sigma(t/T) \varepsilon_{t} + \sum_{k=1}^q \sigma((t-k)/T) b_k(t/T) \varepsilon_{t-k},}
where \eqn{a_1, \ldots, a_p, b_0, b_1, \ldots, b_q} are real-valued functions on \eqn{[0,1]},
\eqn{\sigma} is a positive function on \eqn{[0,1]} and \eqn{\varepsilon_t}
is white noise.
}
\examples{
## Taken from Section 6 in Dahlhaus (1997, AoS)
a1 <- function(u) {1.8 * cos(1.5 - cos(4*pi*u))}
a2 <- function(u) {-0.81}
plot(tvARMA(128, a = list(a1,a2), b = list()), type="l")
}

