% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acfARp.R
\name{acfARp}
\alias{acfARp}
\title{Compute autocovariances of an AR(p) process}
\usage{
acfARp(a = NULL, sigma, k)
}
\arguments{
\item{a}{vector \eqn{(a_1, \ldots, a_p)} of coefficients; default NULL,
corresponding to p = 0, white noise with variance \eqn{\sigma^2},}

\item{sigma}{standard deviation of \eqn{\varepsilon_t}; default 1,}

\item{k}{lag for which to compute the autocovariances.}
}
\value{
Returns autocovariance at lag k of the AR(p) process.
}
\description{
This functions returns the autocovariances \eqn{Cov(X_{t-k}, X_t)} of a
stationary time series \eqn{(Y_t)} that fulfills the following equation:
\deqn{Y_t = \sum_{j=1}^p a_j Y_{t-j} + \sigma \varepsilon_{t},}
where \eqn{\sigma > 0}, \eqn{\varepsilon_t} is white noise and
\eqn{a_1, \ldots, a_p} are real numbers satisfying that the roots
\eqn{z_0} of the polynomial \eqn{1 - \sum_{j=1}^p a_j z^j}
lie strictly outside the unit circle.
}
\examples{
## Taken from Section 6 in Dahlhaus (1997, AoS)
a1 <- function(u) {1.8 * cos(1.5 - cos(4*pi*u))}
a2 <- function(u) {-0.81}
# local autocovariance for u === 1/2: lag 1
acfARp(a = c(a1(1/2), a2(1/2)), sigma = 1, k = 1)
# local autocovariance for u === 1/2: lag -2
acfARp(a = c(a1(1/2), a2(1/2)), sigma = 1, k = -1)
# local autocovariance for u === 1/2: the variance
acfARp(a = c(a1(1/2), a2(1/2)), sigma = 1, k = 0)
}
