% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_inventory.R
\name{fd_inventory_spain}
\alias{fd_inventory_spain}
\title{Download Spanish Forest Inventory}
\usage{
fd_inventory_spain(
  province,
  ifn = 4,
  database = "field",
  path_metadata = NULL,
  quiet = TRUE
)
}
\arguments{
\item{province}{A character string of length 1 with the name of a
Spanish province}

\item{ifn}{Number of Spanish Forest Inventory (from 2 to 4)}

\item{database}{The name of the database (either 'field' or 'gis')}

\item{path_metadata}{A character string of length 1 with the path to store the
metadata of the selected database. The default \code{path_metadata = NULL}
does not download the metadata}

\item{quiet}{If \code{TRUE} (the default), suppress status messages, and
the progress bar}
}
\value{
A \code{list} with the tables
}
\description{
Download the tables and SIG data from the Spanish Forest Inventory
}
\details{
The IFN2 doesn't have 'gis' data for Asturias, Cantabria and Navarra.
}
\examples{
\donttest{
# Download MFE50 for the province of Lugo
lugo_ifn4_lst <- fd_inventory_spain("Lugo")

lugo_ifn3_gis_lst <- fd_inventory_spain("Lugo", ifn = 3, database = "gis")
}
}
\references{
\url{https://www.miteco.gob.es/es/biodiversidad/temas/inventarios-nacionales/inventario-forestal-nacional.html}
}
\seealso{
[metadata_forestdata] for a list of possible species
}
