% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdq_meyer.R
\name{bdq_meyer}
\alias{bdq_meyer}
\title{Classify a forest for selective cutting using the Meyer BDq method}
\usage{
bdq_meyer(
  df,
  plot,
  dbh,
  plot_area,
  class_interval = 5,
  dbh_min = 5,
  licourt_index = 2,
  output = "table"
)
}
\arguments{
\item{df}{A data frame.}

\item{plot}{Quoted name of the plot variable. used to differentiate the plot's trees, and calculate the number of sampled plots.}

\item{dbh}{Quoted name of the diameter at breast height variable, in cm.}

\item{plot_area}{Quoted name of the plot area variable, or a numeric vector with the plot area value. The plot area value must be in square meters.}

\item{class_interval}{Numeric value for the class interval used to classify the data. Default: \code{5}.}

\item{dbh_min}{Numeric value for minimum diameter value to be considered in the classifications. dbh values smaller than this will be dismissed from the classification. Default: \code{5}.}

\item{licourt_index}{Numeric value for the start licourt index used. Default: \code{2}.}

\item{output}{Character value for the desired output. Can be either \code{"table"} for the classified data table, \code{"model"} to get a lm object with the linear model fitted, \code{"coefs"} to get a vector with the Meyer coefficients, or \code{"full"}, to get a list with all restuls. Default: \code{"table"}.}
}
\value{
a data frame, a lm object, a vector or a list, according to the output argument.
}
\description{
This function can be used to plan and execute selective cuttings of a native
forest, without damaging the forest's natural structure.
}
\examples{
library(forestmangr)
data("exfm20")
exfm20

# To get the table with the regulated forest:
bdq_meyer(exfm20, "transect", "dbh", 1000)

# Use different class interval values to get different results:
bdq_meyer(exfm20, "transect", "dbh", 1000, class_interval = 10)

# It's possible to get different outputs:
bdq_meyer(exfm20, "transect", "dbh", 1000, output="model")
bdq_meyer(exfm20, "transect", "dbh", 1000, output="coefs")
bdq_meyer(exfm20, "transect", "dbh", 1000, output="full")


}
\references{
Souza, A. L. and Soares, C. P. B. (2013) Florestas Nativas: estrutura, dinamica e manejo. Vicosa: UFV.
}
\author{
Eric Bastos Gorgens \email{e.gorgens@gmail.com}
}
