% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_helpers.R
\name{heightDetails.xaxis}
\alias{heightDetails.xaxis}
\title{Gets the height for an x-axis object}
\usage{
\method{heightDetails}{xaxis}(x)
}
\arguments{
\item{x}{The \code{\link[grid]{xaxisGrob}} object}
}
\value{
\code{grid::unit} A \code{\link[grid]{unit}} object
}
\description{
A function that gets the height of an \code{\link[grid]{xaxisGrob}}.
It is for some reason not included by default in the \pkg{grid}-package.
}
\examples{
library(grid)
grid.newpage()
xg <- xaxisGrob(c(1:3))
convertY(grobHeight(xg), "lines")
}
\keyword{internal}
