% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_border.R
\name{add_border}
\alias{add_border}
\alias{add_underline}
\title{Add border to cells}
\usage{
add_border(
  plot,
  row = NULL,
  col = NULL,
  part = c("body", "header"),
  where = c("bottom", "left", "top", "right"),
  gp = gpar(lwd = 2)
)

add_underline(
  plot,
  row = NULL,
  col = NULL,
  part = c("body", "header"),
  gp = gpar(lwd = 2)
)
}
\arguments{
\item{plot}{A forest plot object.}

\item{row}{A numeric value or vector indicating row number to add border.
This is corresponding to the data row number. Remember to account for any
text inserted. A border will be drawn to all rows if this is omitted.}

\item{col}{A numeric value or vector indicating the columns to add border.
A border will be drawn to all columns if this is omitted.}

\item{part}{The border will be added to \code{"body"} (default) or
\code{"header"}.}

\item{where}{Where to draw the border of the cell, possible values are
\code{"bottom"} (default), \code{"left"}, \code{"top"} and \code{"right"}}

\item{gp}{An object of class \code{"gpar"}, graphical parameter to be passed
to \code{\link[grid]{segmentsGrob}}.}
}
\value{
A \code{\link[gtable]{gtable}} object.
}
\description{
Add border to any cells at any side.

\code{\link{add_underline}} is a wrapper of \code{\link{add_border}} can be used to add
underline to cells.
}
\seealso{
\code{\link[grid]{gpar}} \code{\link[grid]{segmentsGrob}} \code{\link[gtable]{gtable_add_grob}}
}
