% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_pcl.R
\name{process_pcl}
\alias{process_pcl}
\title{Process single PCL transects.}
\usage{
process_pcl(
  f,
  user_height,
  marker.spacing,
  max.vai,
  pavd = FALSE,
  hist = FALSE,
  save_output = TRUE
)
}
\arguments{
\item{f}{the name of the filename to input <character> or a data frame <data frame>.}

\item{user_height}{the height of the laser off the ground as mounted on the user
in meters. default is 1 m}

\item{marker.spacing}{distance between markers, defaults is 10 m}

\item{max.vai}{the maximum value of column VAI. The default is 8. Should be
a max value, not a mean.}

\item{pavd}{logical input to include Plant Area Volume Density Plot from {plot_pavd},
if TRUE it is included, if FALSE, it is not.}

\item{hist}{logical input to include histogram of VAI with PAVD plot, if
TRUE it is included, if FALSE, it is not.}

\item{save_output}{the name of the output folder where to write all the output fiels.}
}
\value{
writes the hit matrix, summary matrix, and output variables to csv
in an output folder, along with hit grid plot
}
\description{
\code{process_pcl} imports and processes a single PCL transect.
}
\details{
This function imports raw pcl data or existing data frames of pcl data and writes
all data and analysis to a series of .csv files in an output directory (output)
keeping nothing in the workspace.

\code{process_pcl} uses a workflow that cuts the data into 1 meter segments with
z and x positions in coordinate space where x referes to distance along the ground
and z refers to distance above the ground. Data are normalized based on
light extinction assumptions from the Beer-Lambert Law to account for light saturation.
Data are then summarized and metrics of canopy structure complexity are calculated.

\code{process_pcl} will write multiple output files to disk in an output directory that
 \code{process_pcl} creates within the work directing. These files include:

1. an output variables file that contains a list of CSC variables and is
written by the subfunction \code{write_pcl_to_csv}
2. a summary matrix, that includes detailed information on each vertical column
of LiDAR data written by the subfunction \code{write_summary_matrix_to_csv}
3. a hit matrix, which is a matrix of VAI at each x and z position, written by the
subfunction \code{write_hit_matrix_to_pcl}
4. a hit grid, which is a graphical representation of VAI along the x and z coordinate space.
5. optionally, plant area/volume density profiles can be created by including
\code{pavd = TRUE} that include an additional histogram with the optional
\code{hist = TRUE} in the \code{process_pcl} call.
}
\examples{

# Run process complete PCL transect without storing to disk
uva.pcl <- system.file("extdata", "UVAX_A4_01W.csv", package = "forestr")

process_pcl(uva.pcl, marker.spacing = 10, user_height = 1.05,
max.vai = 8, pavd = FALSE, hist = FALSE, save_output = FALSE)

# with data frame
process_pcl(osbs, marker.spacing = 10, user_height = 1.05,
max.vai = 8, pavd = FALSE, hist = FALSE, save_output = FALSE)


}
\seealso{
\code{\link{process_multi_pcl}}
}
\keyword{pcl}
\keyword{processing}
