% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_form.R
\name{ref_df_row}
\alias{ref_df_row}
\title{Create a row for a referential footnote information dataframe}
\usage{
ref_df_row(
  row_path = NA_character_,
  col_path = NA_character_,
  row = NA_integer_,
  col = NA_integer_,
  symbol = NA_character_,
  ref_index = NA_integer_,
  msg = NA_character_,
  max_width = NULL
)
}
\arguments{
\item{row_path}{character. row path (\code{NA_character_} for none)}

\item{col_path}{character. column path (\code{NA_character_} for none)}

\item{row}{integer(1). Integer position of the row.}

\item{col}{integer(1). Integer position of the column.}

\item{symbol}{character(1). Symbol for the reference. \code{NA_character_} to use the \code{ref_index} automatically.}

\item{ref_index}{integer(1). The index of the footnote, used for ordering even when symbol is not NA}

\item{msg}{character(1). The string message, not including the symbol portion (\verb{\{symbol\} - })}

\item{max_width}{numeric(1). Width strings should be wrapped to
when determining how many lines they require.}
}
\value{
a single row data.frame with the appropriate columns.
}
\description{
Create a row for a referential footnote information dataframe
}
