% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tostring.R
\name{decimal_align}
\alias{decimal_align}
\title{Decimal alignment}
\usage{
decimal_align(string_mat, align_mat)
}
\arguments{
\item{string_mat}{(\verb{character matrix})\cr "string" matrix component of \code{MatrixPrintForm} object.}

\item{align_mat}{(\verb{character matrix})\cr "aligns" matrix component of \code{MatrixPrintForm} object.
Should contain either \code{dec_left}, \code{dec_right}, or \code{decimal} for values to be decimal aligned.}
}
\value{
A processed string matrix of class \code{MatrixPrintForm} with decimal-aligned values.
}
\description{
Aligning decimal values of string matrix. Allowed alignments are: \code{dec_left}, \code{dec_right},
and \code{decimal}.
}
\details{
Left and right decimal alignment (\code{dec_left} and \code{dec_right}) differ from center decimal
alignment (\code{decimal}) only when there is padding present. This may occur if column widths are
set wider via parameters \code{widths} in \code{toString} or \code{colwidths} in \verb{paginate_*}. More commonly,
it also occurs when column names are wider. Cell wrapping is not supported when decimal
alignment is used.
}
\examples{
dfmf <- basic_matrix_form(mtcars[1:5, ])
aligns <- mf_aligns(dfmf)
aligns[, -c(1)] <- "dec_left"
decimal_align(mf_strings(dfmf), aligns)

}
\seealso{
\code{\link[=toString]{toString()}}, \code{\link[=MatrixPrintForm]{MatrixPrintForm()}}
}
