% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_form.R
\name{ref_df_row}
\alias{ref_df_row}
\title{Create a row for a referential footnote information data frame}
\usage{
ref_df_row(
  row_path = NA_character_,
  col_path = NA_character_,
  row = NA_integer_,
  col = NA_integer_,
  symbol = NA_character_,
  ref_index = NA_integer_,
  msg = NA_character_,
  max_width = NULL
)
}
\arguments{
\item{row_path}{(\code{character})\cr row path (or \code{NA_character_} for none).}

\item{col_path}{(\code{character})\cr column path (or \code{NA_character_} for none).}

\item{row}{(\code{integer(1)})\cr integer position of the row.}

\item{col}{(\code{integer(1)})\cr integer position of the column.}

\item{symbol}{(\code{string})\cr symbol for the reference. \code{NA_character_} to use the
\code{ref_index} automatically.}

\item{ref_index}{(\code{integer(1)})\cr index of the footnote, used for ordering even when
symbol is not \code{NA}.}

\item{msg}{(\code{string})\cr the string message, not including the symbol portion (\verb{\{symbol\} - })}

\item{max_width}{(\code{numeric(1)})\cr width that strings should be wrapped to when
determining how many lines they require.}
}
\value{
A single row data frame with the appropriate columns.
}
\description{
Create a row for a referential footnote information data frame
}
