% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingPersonIP.R
\name{missingPersonIP}
\alias{missingPersonIP}
\title{Inclusion power for missing person cases}
\usage{
missingPersonIP(
  reference,
  missing,
  markers,
  nsim = 1,
  threshold = NULL,
  disableMutations = NA,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{reference}{A \code{ped} object with attached markers.}

\item{missing}{The ID label of the missing pedigree member.}

\item{markers}{A vector indicating the names or indices of markers attached
to the source pedigree. If NULL (default), then all markers attached to the
source pedigree are used. If \code{alleles} or \code{afreq} is non-NULL, then this
parameter is ignored.}

\item{nsim}{A positive integer: the number of simulations}

\item{threshold}{A numeric vector with one or more positive numbers used as
the likelihood ratio thresholds for inclusion}

\item{disableMutations}{This parameter determines how mutation models are
treated. Possible values are as follows:
\itemize{
\item \code{NA} (the default): Mutations are disabled only for those markers whose
known genotypes are consistent with \code{reference}. This is determined by
temporarily removing all mutation models and checking which markers have
nonzero likelihood.
\item \code{TRUE}: Mutations are disabled for all markers. This will result in an
error if any markers are inconsistent with \code{reference}.
\item \code{FALSE}: No action is done to disable mutations.
\item A vector containing the names or indices of those markers for which
mutations should be disabled.
}}

\item{seed}{A numeric seed for the random number generator (optional)}

\item{verbose}{A logical.}
}
\value{
A \code{mpIP} object, which is essentially a list with the following
entries:
\itemize{
\item \code{LRperSim}: A numeric vector of length \code{nsim} containing the total LR for
each simulation.
\item \code{meanLRperMarker}: The mean LR per marker, over all simulations.
\item \code{meanLR}: The mean total LR over all simulations.
\item \code{meanLogLR}: The mean total \code{log10(LR)} over all simulations.
\item \code{IP}: A named numeric of the same length as \code{threshold}. For each element
of \code{threshold}, the fraction of simulations resulting in a LR exceeding the
given number.
\item \code{time}: The total computation time.
\item \code{params}: A list containing the input parameters \code{missing}, \code{markers},
\code{nsim}, \code{threshold} and \code{disableMutations}
}
}
\description{
Inclusion power for missing person cases
}
\examples{

# Four siblings; the fourth is missing
x = nuclearPed(4)

# Remaining sibs typed with 5 triallelic markers
x = markerSim(x, N = 5, ids = 3:5, alleles = 1:3, seed = 123, verbose = FALSE)

# Compute exclusion power statistics
missingPersonIP(x, missing = 6, nsim = 5, threshold = c(10, 100))

# Compare with genotypes
x

}
