% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappaBootstrap.R
\name{kappaBootstrap}
\alias{kappaBootstrap}
\alias{deltaBootstrap}
\title{Bootstrap estimation of IBD coefficients}
\usage{
kappaBootstrap(kappa, N, freqList, plot = TRUE)

deltaBootstrap(delta, N, freqList)
}
\arguments{
\item{kappa, delta}{A probability vector of length 3 (kappa) or 9 (delta): The
coefficients under which simulations are performed.}

\item{N}{The number of simulations.}

\item{freqList}{A list of probability vectors: The allele frequencies for
each marker.}

\item{plot}{A logical. If TRUE, the bootstrap kappa estimates are plotted in
the IBD triangle.}
}
\value{
A data frame with \code{N} rows containing the bootstrap estimates. The
last column (\code{dist}) gives the euclidean distance to the input, viewed as a
point in R^3 (kappa) or R^9 (delta).
}
\description{
These functions produce (parametric) bootstrap estimates of the IBD
coefficients between two individuals. Both kappa coefficients (for noninbred
individuals) and the 9 condensed identity coefficients are supported.
}
\details{
In each replication, profiles for two individuals are simulated under the
input coefficients, and their relationship is re-estimated with \code{\link[=ibdEstim]{ibdEstim()}}.
}
\examples{

# Frequency list of 15 standard STR markers
freqList = NorwegianFrequencies[1:15]

# Number of bootstrap simulations (increase!)
N = 5

# Bootstrap estimates for kappa of full siblings
boot1 = kappaBootstrap(c(0.25, .5, .25), N = N, freqList = freqList)
boot1

# Mean deviation
mean(boot1$dist)

# Same, but with the 9 identity coefficients.
delta = c(0, 0, 0, 0, 0, 0, .25, .5, .25)
boot2 = deltaBootstrap(delta, N = N, freqList = freqList)

# Mean deviation
mean(boot2$dist)

}
