% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wcfpof.R
\name{WCFPOF}
\alias{WCFPOF}
\title{WCFPOF algorithm}
\usage{
WCFPOF(data, minSupport = 0.3, mlen = 0, noCores = 1)
}
\arguments{
\item{data}{\code{data.frame} or \code{transactions} from \code{arules} with input data}

\item{minSupport}{minimum support for FPM}

\item{mlen}{maximum length of frequent itemsets}

\item{noCores}{number of cores for parallel computation}
}
\value{
model output (list) with all results including outlier scores
}
\description{
Algorithm proposed by:
Jiadong Ren, Qunhui Wu,  Jiadong Ren, Changzhen Hu, Kunsheng Wang - An Approach for Analyzing Infrequent Software Faults Based on Outlier Detection
}
\examples{
library("fpmoutliers")
dataFrame <- read.csv(
     system.file("extdata", "fp-outlier-customer-data.csv", package = "fpmoutliers"))
model <- WCFPOF(dataFrame, minSupport = 0.001)
}
