% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_assessment.R
\name{download_assessment}
\alias{download_assessment}
\title{Download a single floristic quality assessment}
\usage{
download_assessment(assessment_id)
}
\arguments{
\item{assessment_id}{A numeric identifier of the desired floristic quality
assessment, as specified by
\href{https://universalfqa.org/}{universalfqa.org}. ID numbers for
assessments in specified databases can be viewed with the
\code{\link[=index_fqa_assessments]{index_fqa_assessments()}} function.}
}
\value{
An untidy data frame in the original format of the Universal FQA
  website. Use \code{\link[=assessment_glance]{assessment_glance()}} for a
  tidy summary and
  \code{\link[=assessment_inventory]{assessment_inventory()}} for
  species-level data.
}
\description{
\code{download_assessment()} retrieves a specified floristic quality
assessment from \href{https://universalfqa.org/}{universalfqa.org}. ID
numbers for assessments in various databases can be found using the
\code{\link[=index_fqa_assessments]{index_fqa_assessments()}} function.
}
\examples{
\donttest{

databases <- index_fqa_databases()
# Note database 1 is the original 1994 Chicago edition.

chicago_assessments <- index_fqa_assessments(1) # Edison dune and swale has id number 25002.
edison <- download_assessment(25002)

edison_tidy <- assessment_glance(edison)
edison_species <- assessment_inventory(edison)
}

}
