% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transect_list_inventory.R
\name{transect_list_inventory}
\alias{transect_list_inventory}
\title{Obtain species details for a list of transect assessments}
\usage{
transect_list_inventory(transect_list)
}
\arguments{
\item{transect_list}{A list of data sets downloaded from
\href{https://universalfqa.org/}{universalfqa.org}, typically using
\code{\link[=download_transect_list]{download_transect_list()}}.}
}
\value{
A list of data frames, each with 13 columns:
\itemize{
   \item species (character)
   \item family (character)
   \item acronym (character)
   \item nativity (character)
   \item c (numeric)
   \item w (numeric)
   \item physiognomy (character)
   \item duration (character)
   \item frequency (numeric)
   \item coverage (numeric)
   \item relative_frequency_percent (numeric)
   \item relative_coverage_percent (numeric)
   \item relative_importance_value (numeric)
}
}
\description{
\code{transect_list_inventory()} returns a list of data frames, each of which
consists of all plant species included in a floristic quality assessment of a transect
obtained from \href{https://universalfqa.org/}{universalfqa.org}.
}
\examples{
\donttest{
# While transect_list_inventory can be used with a list of .csv file downloaded
# manually from the universal FQA website, it is most typically used
# in combination with download_transect_list()

chicago <- download_transect_list(database = 149)
chicago_invs <- transect_list_inventory(chicago)
}

}
