% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vfractional.R
\name{numerators}
\alias{denominators}
\alias{denominators.charFrac}
\alias{denominators.default}
\alias{denominators.fractional}
\alias{numerators}
\alias{numerators.charFrac}
\alias{numerators.default}
\alias{numerators.fractional}
\title{Extract the parts of a fractional object}
\usage{
numerators(x)

\method{numerators}{charFrac}(x)

\method{numerators}{fractional}(x)

\method{numerators}{default}(x)

denominators(x)

\method{denominators}{charFrac}(x)

\method{denominators}{fractional}(x)

\method{denominators}{default}(x)
}
\arguments{
\item{x}{An object of class \code{"fractional"} or
\code{"charFrac"}}
}
\value{
An \code{integer} vector of numerators

An \code{integer} vector of denominators
}
\description{
Generic function for extracting numerators with methods for \code{"fractional"} or
\code{"charFrac"} objects

Generic function for extracting denominators with methods for \code{"fractional"} or
\code{"charFrac"} objects
}
\section{Methods (by class)}{
\itemize{
\item \code{charFrac}: \code{numerators} method function for \code{"charFrac"} objects

\item \code{fractional}: \code{numerators} method function for \code{"fractional"} objects

\item \code{default}: Default \code{numerators} method for \code{numeric} objects

\item \code{charFrac}: \code{denominators} method function for \code{"charFrac"} objects

\item \code{fractional}: \code{denominators} method function for \code{"fractional"} objects

\item \code{default}: Default \code{denominators} method for \code{numeric} objects
}}
\examples{
(pi_approx <- vfractional(base::pi, eps = 0, maxConv = 1:10))
numerators(pi_approx)
denominators(pi_approx)
}

