% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survivalfragility.R
\name{survivalfragility}
\alias{survivalfragility}
\title{Survival fragility function}
\usage{
survivalfragility(formula, data, niter, conf.level = 0.95,
  progress.bar = FALSE)
}
\arguments{
\item{formula}{Model formula which will be evaluated by glm()}

\item{data}{Dataframe with values for model forma, passed to glm()}

\item{niter}{Number of iterations of algorithm to run}

\item{conf.level}{Significance level, set by default to 95\%}

\item{progress.bar}{Print a progress bar?}
}
\value{
Returns the mean fragility index for a niter calculations
}
\description{
Compute the fragility of a coefficient in a survival test. Wrapper function for logisticfragilityinternal. Uses the survdiff() function from the survival package.
}
\examples{
library(survival)
lung$status = lung$status - 1 # recode status as a 0/1 variable (mandatory)

survivalfragility(Surv(time, status) ~ pat.karno + strata(inst),
                  data=lung, niter=10, progress.bar = FALSE)

}

