% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot_emfrail}
\alias{plot_emfrail}
\alias{plot_pred}
\alias{plot_hr}
\alias{hist_frail}
\title{Plot functions for \code{emfrail} objects}
\usage{
plot_pred(object, lp = 0, newdata = NULL, quantity = "cumhaz",
  type = "both", conf_int = "adjusted", ...)

plot_hr(object, lp, newdata = NULL, ...)

hist_frail(object, ...)
}
\arguments{
\item{object}{An \code{emfrail} object}

\item{lp}{The value(s) of the linear predictor. For \code{plot_pred} this should have length 1 and for \code{plot_hr} length 2.}

\item{newdata}{A \code{data.frame} from each each line corresponds to a value of the linear predictor (optional). For \code{plot_pred} this should have 1 row and for \code{plot_hr} 2 rows.}

\item{quantity}{One of "cumhaz" (for cumulative hazard) or "survival"}

\item{type}{One of "conditional", "marginal" or "both"}

\item{conf_int}{One of "adjusted", "regular", or "none}

\item{...}{Parameters passed on to plot functions}
}
\value{
Nothing.
}
\description{
\code{plot_pred} plots predicted cumulative hazard or survival curves, marginal and / or conditional, with or without confidence intervals.

\code{plot_hr} plots the estimated marginal and conditional hazard ratio between two units with different linear predictor values.

\code{hist_frail} plots a histogram of the estimated frailties.
}
\details{
These functions exist mostly for conveince. They are in fact simple wrappers that use \code{predict.emfrail} or \code{summary.emfrail} on
\code{object}, and extract some quantities of interest. Nicer plots can be obtained manually;
in the documentation of \code{emfrail}, \code{emfrail_pll}, \code{summary.emfrail}, \code{predict.emfrail}
several examples can be found.
}
\examples{
mod_rec <- emfrail(bladder1, Surv(start, stop, status) ~ treatment + number + cluster(id))
summary(mod_rec)

# cumulative hazard
# Note: this individual has number = 0, which does not exist in the data
plot_pred(mod_rec)

# survival, although not very meaningful with recurrent events
plot_pred(mod_rec, quantity = "survival")


# For an individual with number == 2
plot_pred(mod_rec, newdata = data.frame(treatment = "placebo", number = 2))

# hazard ratio between an individual with 0 and with 2 recurrences at baseline
# the marginal hazard ratio is "pulled" towards 1:
plot_hr(mod_rec, newdata = data.frame(treatment = "placebo", number = c(0, 2)))

# hazard ratio with the stable distribution:
mod_rec_stab <- emfrail(bladder1,
                        Surv(start, stop, status) ~ treatment + number + cluster(id),
                        .distribution = emfrail_distribution(dist = "stable"))

plot_hr(mod_rec_stab, newdata = data.frame(treatment = "placebo", number = c(0, 2)))

# histogram of frailty estimates
hist_frail(mod_rec_stab)


}
\seealso{
\code{\link{predict.emfrail}}, \code{\link{summary.emfrail}}.
}
