% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca_test_cph.R
\name{ca_test}
\alias{ca_test}
\title{Commenges-Andersen test for heterogeneity}
\usage{
ca_test(object, id = NULL)
}
\arguments{
\item{object}{A \code{coxph} object with a \code{cluster()} statement in the right-hand side of the formula.}

\item{id}{Optionally, a vector determining the grouping to be tested. See details.}
}
\value{
A named vector containing the test statistic, variance, and p-value
}
\description{
Commenges-Andersen test for heterogeneity
}
\details{
The Cox model with a \code{+cluster()} statement has the same point estimates
as the one without that statmenet. The only difference is in the adjusted standard errors.
In some cases, a model with \code{+cluster()} statments can't be fitted. For example, when there
are no covariates. In that case, a vector may be passed on in the \code{cluster} argument.
}
\examples{
mcox1 <- coxph(Surv(time, status) ~ rx + sex + cluster(litter),
rats, model = TRUE, x = TRUE)
ca_test(mcox1)

mcox2 <- coxph(Surv(time, status) ~ 1, rats, x = TRUE)
ca_test(mcox2, rats$litter)
}
\references{
Commenges, D. and Andersen, P.K., 1995. Score test of homogeneity for survival data. Lifetime Data Analysis, 1(2), pp.145-156.
}
