% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_otherwise.R
\name{select_otherwise}
\alias{select_otherwise}
\title{select_otherwise}
\usage{
select_otherwise(
  .data,
  ...,
  otherwise = NULL,
  col = NULL,
  return_type = c("names", "index", "df")
)
}
\arguments{
\item{.data}{dataframe}

\item{...}{tidyselect. columns to choose}

\item{otherwise}{tidyselect. default columns to choose if ... is not specified}

\item{col}{tidyselect. column to choose regardless of ... or otherwise specifications}

\item{return_type}{choose to return column index, names, or df. defaults to index}
}
\value{
integer vector by default. possibly data frame or character vector
}
\description{
flexible select operator that powers the tidy consultant universe. Used to set sensible defaults
and flexibly return the chosen columns. A developer focused function, but may be useful in
interactive programming due to the ability to return different types.
}
\examples{

iris \%>\%
select_otherwise(where(is.double), return_type = "index")
}
