% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_release_dates.R
\name{fredr_release_dates}
\alias{fredr_release_dates}
\title{Get release dates for a single release of economic data}
\usage{
fredr_release_dates(
  release_id,
  ...,
  limit = NULL,
  offset = NULL,
  sort_order = NULL,
  include_release_dates_with_no_data = NULL,
  realtime_start = NULL,
  realtime_end = NULL
)
}
\arguments{
\item{release_id}{An integer ID of the release.}

\item{...}{These dots only exist for future extensions and should be empty.}

\item{limit}{An integer limit on the maximum number of results to return.
Defaults to \code{10000}, the maximum.}

\item{offset}{An integer used in conjunction with \code{limit} for long series.
This mimics the idea of \emph{pagination} to retrieve large amounts of data over
multiple calls. Defaults to \code{0}.}

\item{sort_order}{A string representing the order of the resulting release
dates. Possible values are: \code{"asc"} (default), and \code{"desc"}.}

\item{include_release_dates_with_no_data}{A boolean value indicating if the
results with no data available should be returned as well.
Default is \code{FALSE}.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to \code{1776-07-04} (earliest available). For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to \code{9999-12-31} (latest available). For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object.
}
\description{
Get release dates for a single release of economic data
}
\section{API Documentation}{


\href{https://fred.stlouisfed.org/docs/api/fred/release_dates.html}{fred/release/dates}
}

\examples{
if (fredr_has_key()) {
fredr_release_dates(release_id = 20L)

# Call the function with an "as of" Date of 1997-03-14
fredr_release_dates(release_id = 20L, realtime_end = as.Date("1997-03-14"))
}
}
\seealso{
\code{\link[=fredr_releases]{fredr_releases()}}, \code{\link[=fredr_releases_dates]{fredr_releases_dates()}}, \code{\link[=fredr_release]{fredr_release()}},
\code{\link[=fredr_release_series]{fredr_release_series()}}, \code{\link[=fredr_release_sources]{fredr_release_sources()}}, \code{\link[=fredr_release_tags]{fredr_release_tags()}},
\code{\link[=fredr_release_related_tags]{fredr_release_related_tags()}}, \code{\link[=fredr_release_tables]{fredr_release_tables()}}
}
