### R code from vignette source 'adjoint.Rnw'

###################################################
### code chunk number 1: adjoint.Rnw:63-64
###################################################
library("freealg")


###################################################
### code chunk number 2: adjoint.Rnw:70-71
###################################################
ad


###################################################
### code chunk number 3: adjoint.Rnw:81-84
###################################################
X <- as.freealg("X")
Y <- as.freealg("Y")
.[X,Y]


###################################################
### code chunk number 4: adjoint.Rnw:91-97
###################################################
X <- rfalg(3)
Y <- rfalg(3)
Z <- rfalg(3)
X # Y and Z are similar objects
.[X,Y] # quite complicated
.[X,.[Y,Z]] + .[Y,.[Z,X]] + .[Z,.[X,Y]]  # Zero by Jacobi


###################################################
### code chunk number 5: adjoint.Rnw:112-113
###################################################
ad(X)


###################################################
### code chunk number 6: adjoint.Rnw:118-121
###################################################
f <- ad(X)
f(Y)
f(Y) == X*Y-Y*X


###################################################
### code chunk number 7: adjoint.Rnw:130-132
###################################################
phi <- ad(Z)
phi(.[X,Y]) == .[phi(X),phi(Y)]


###################################################
### code chunk number 8: repeatedad
###################################################
f <- ad(as.freealg("x"))
f(f(f(f(f(as.freealg("y"))))))


###################################################
### code chunk number 9: verifyderivation
###################################################
phi <- ad(X)
phi(.[Y,Z]) == .[phi(Y),Z] + .[Y,phi(Z)]


###################################################
### code chunk number 10: adjoint.Rnw:173-174
###################################################
ad(.[X,Y])(Z) == .[ad(X),ad(Y)](Z)


###################################################
### code chunk number 11: adjoint.Rnw:180-181
###################################################
.[ad(X),ad(Y)]


###################################################
### code chunk number 12: adjoint.Rnw:193-196
###################################################
f <- ad(matrix(c(4,6,2,3),2,2))
M <- matrix(1:4,2,2)
f(M)


