\name{dot-class}
\docType{class}
\alias{dot}
\alias{.}
\alias{dot-class}
\alias{extract}
\alias{commutator}
\alias{jacobi}
\alias{dot_error}
\alias{[.dot}
\alias{[,dot-method}
\alias{[,dot,ANY,ANY-method}
\alias{[,dot,ANY,missing-method}
\alias{[,dot,missing,ANY-method}
\alias{[,dot,missing,missing-method}
\alias{[,dot,matrix,matrix-method}
\alias{[,dot,function,function-method}
\alias{[,dot,ANY,ANY,ANY-method}
\alias{[,dot,ANY,missing,ANY-method}
\alias{[,dot,function,function,ANY-method}
\alias{[,dot,matrix,matrix,ANY-method}
\alias{[,dot,missing,ANY,ANY-method}
\alias{[,dot,missing,missing,ANY-method}
\title{Class \dQuote{dot}}
\description{\loadmathjax

The dot object is defined so that idiom like \code{.[x,y]} returns the
commutator, that is, \code{xy-yx} or the Lie bracket \mjseqn{[x,y]}.  It
would have been nice to use \code{[x,y]} (that is, without the dot) but
although this is syntactically consistent, it cannot be done in R.

The \dQuote{meat} of the package is:

\preformatted{
setClass("dot", slots = c(ignore='numeric'))
`.` <- new("dot")
setMethod("[",signature(x="dot",i="ANY",j="ANY"),function(x,i,j,drop){i*j-j*i})
}

The package code includes other bits and pieces such as informative
error messages for idiom such as \code{.[]}.  The package defines a
matrix method for the dot object.  This is because \dQuote{\code{*}}
returns (incorrectly, in my view) the elementwise product, not the
matrix product.

The Jacobi identity, satisfied by any associative algebra, is

\mjdeqn{
  \left[x,\left[y,z\right]\right]+
  \left[y,\left[z,x\right]\right]+
  \left[z,\left[x,y\right]\right]=0
}{
  [x,[y,z]] + [y,[z,x]] + [z,[x,y]] = 0
}

and the left hand side is returned by \code{jacobi()}, which should be
zero (for some definition of \dQuote{zero}).

Function \code{ad()} returns the adjoint operator.  The \code{adjoint}
vignette provides details and examples of the adjoint operator.

The dot object is generated by running script \code{inst/dot.Rmd}, which
includes some further discussion and technical documentation, and
creates file \code{dot.rda} which resides in the \code{data/} directory.

}
\section{Slots}{
  \describe{
    \item{\code{ignore}:}{Object of class \code{"numeric"}, just a
      formal placeholder}
  }
}
\section{Methods}{
  \describe{
    \item{[}{\code{signature(x = "dot", i = "ANY", j = "ANY")}: ... }
    \item{[}{\code{signature(x = "dot", i = "ANY", j = "missing")}: ... }
    \item{[}{\code{signature(x = "dot", i = "function", j = "function")}: ... }
    \item{[}{\code{signature(x = "dot", i = "matrix", j = "matrix")}: ... }
    \item{[}{\code{signature(x = "dot", i = "missing", j = "ANY")}: ... }
    \item{[}{\code{signature(x = "dot", i = "missing", j = "missing")}: ... }
	 }
}
\value{
  Always returns an object of the same class as \code{xy}.
}
\author{Robin K. S. Hankin}
\examples{

.[as.freealg("x"),as.freealg("y")]
.[as.freealg("x"),as.freealg("y+2z")]
.[as.freealg("x+y+2xYx"),as.freealg("x+y+2xYx")]


x <- rfalg()
y <- rfalg()
z <- rfalg()

jacobi(x,y,z) # Jacobi identity
.[x,.[y,z]] + .[y,.[z,x]] + .[z,.[x,y]]  # Jacobi, expanded


f <- ad(x)
f(y)


rM <- function(...){matrix(sample(1:9,9),3,3)} # a random matrix

M <- rM()
N <- rM()
O <- rM()

.[M,N]
jacobi(M,N,O)

}
