% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mris_convert.R
\name{mris_convert}
\alias{mris_convert}
\title{Use Freesurfers MRIs Converter}
\usage{
mris_convert(infile, outfile = NULL, ext = ".asc", opts = "",
  verbose = TRUE)
}
\arguments{
\item{infile}{(character) file path for input file}

\item{outfile}{(character) output file path}

\item{ext}{(character) output file extension, default is set to .asc}

\item{opts}{(character) additional options to add to front of command}

\item{verbose}{(logical) print diagnostic messages}
}
\value{
Name of output file
}
\description{
This function call  \code{mris_convert}, a 
general conversion program for converting between cortical surface file formats
}
\examples{
if (have_fs()) {
 bert_surf_dir = file.path(fs_subj_dir(), "bert", "surf")
 asc_file = mris_convert(
 infile = file.path(bert_surf_dir, "lh.white")
 )  
} 
}
