% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_nifti2.R
\name{write.nifti2}
\alias{write.nifti2}
\title{Write header and data to a file in NIFTI v2 format.}
\usage{
write.nifti2(filepath, niidata, niiheader = NULL)
}
\arguments{
\item{filepath}{the file to write. The extension should be '.nii' or '.nii.gz'.}

\item{niidata}{array of numeric or integer data, with up to 7 dimensions. Will be written to the file with the datatype and bitpix specified in the 'niiheader' argument.}

\item{niiheader}{an optional NIFTI v2 header that is suitable for the passed 'niidata'. If not given, one will be generated with \code{\link{ni2header.for.data}}.}
}
\description{
Write header and data to a file in NIFTI v2 format.
}
\seealso{
Other nifti2 writers: 
\code{\link{write.fs.morph.ni2}()}
}
\concept{nifti2 writers}
