% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_label.R
\name{read.fs.label}
\alias{read.fs.label}
\title{Read a label file.}
\usage{
read.fs.label(filepath, format = "auto", ...)
}
\arguments{
\item{filepath}{string. Full path to the input label file.}

\item{format}{character string, one of 'auto' to detect by file extension, 'asc' for native FreeSurfer ASCII label format, or 'gii' for GIFTI label format.}

\item{...}{extra paramters passed to the respective label function for the format}
}
\description{
Read a label file.
}
\note{
See \code{\link{read.fs.label.native}} for more details, including important information on loading FreeSurfer volume labels.
}
\examples{
    labelfile = system.file("extdata", "lh.entorhinal_exvivo.label",
      package = "freesurferformats", mustWork = TRUE);
    label = read.fs.label(labelfile);
}
\seealso{
Other label functions: 
\code{\link{read.fs.label.gii}()},
\code{\link{read.fs.label.native}()},
\code{\link{write.fs.label}()}
}
\concept{label functions}
