% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_surface.R
\name{read.fs.surface.stl}
\alias{read.fs.surface.stl}
\title{Read mesh in STL format, auto-detecting ASCII versus binary format version.}
\usage{
read.fs.surface.stl(filepath, digits = 6L, is_ascii = "auto")
}
\arguments{
\item{filepath}{full path to surface mesh file in STL format.}

\item{digits}{the precision (number of digits after decimal separator) to use when determining whether two x,y,z coords define the same vertex. This is used when the polygon soup is turned into an indexed mesh.}

\item{is_ascii}{logical, whether the file is in the ASCII version of the STL format (as opposed to the binary version). Can also be the character string 'auto', in which case the function will try to auto-detect the format.}
}
\value{
an `fs.surface` instance, the mesh.
}
\description{
Read mesh in STL format, auto-detecting ASCII versus binary format version.
}
\note{
The mesh is stored in the file as a polygon soup, which is transformed into an index mesh by this function.
}
