% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fs_weight.R
\name{read.fs.weight.asc}
\alias{read.fs.weight.asc}
\title{Read ASCII version of FreeSurfer weight file.}
\usage{
read.fs.weight.asc(filepath)
}
\arguments{
\item{filepath}{string. Full path to the input weight file, must be in ASCII weight format.}
}
\value{
the indices and weight data, as a named list. Entries: "vertex_indices": vector of *n* vertex indices. They are stored zero-based in the file, but are returned one-based (R-style). "value": double vector of length *n*, the morphometry data for the vertices. The data can be whatever you want.
}
\description{
Read ASCII version of FreeSurfer weight file. Called by \code{\link[freesurferformats]{read.fs.weight}} if parameter `format` is set to 'asc'.
}
\keyword{internal}
