% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lagreg.est.R
\name{lagreg.est}
\alias{lagreg.est}
\title{Estimate the optimal dimension in linear regression problem}
\usage{
lagreg.est(X, Y, lags = -5:5, K = NULL, Kconst = 1)
}
\arguments{
\item{X}{regressors process}

\item{Y}{response process}

\item{lags}{lags which should be estimated}

\item{K}{how many directions should be inverted (as in \code{\link{pseudoinverse}})}

\item{Kconst}{constant for heuristic (as in \code{\link{reg.dim.est}})}
}
\value{
Estimated regression operator
}
\description{
Estimate regression operator \eqn{P_k} (matrices \eqn{d \times d}) in model
\deqn{Y_t = \sum_{l \in L} P_k X_{t-l} + \varepsilon_t,} where \eqn{X_t} is a \eqn{d}-dimensional stationary process
and \eqn{\varepsilon_t} forms a white noise.
}
\examples{
X = rar(100)
e = rar(100)
Y = X + 0.3 * e
Psi = lagreg.est(X,Y,lags=0:2)
}
\references{
Siegfried Hormann and Lukasz Kidzinski
A note on estimation in Hilbertian linear models
Research report, 2012
}
\seealso{
\code{\link{reg.dim.est}}, \code{\link{speclagreg}}
}

