% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rar.R
\name{rar}
\alias{rar}
\title{Simulate a multivariate autoregressive time series}
\usage{
rar(n, d = NULL, Psi = NULL, first = NULL, noise = NULL, sd = 1)
}
\arguments{
\item{n}{number of observations to generate}

\item{d}{dimension of the process}

\item{Psi}{serie of regression operators (if one matrix is given it is treated as regressor with lag 1)}

\item{first}{the first element of a series}

\item{noise}{the noise we want to add}

\item{sd}{standard deviation of the gaussian noise if the noise wasn't provided}
}
\value{
an AR series of vectors
}
\description{
Simulate \code{n} observarions multivariate autoregressive time series, i.e.
\deqn{ X_t = \sum_{k=0}^p A_k X_{t-k} + \varepsilon_t,}
where \eqn{\varepsilon_t} is a \code{d}-dimensional white noise and \eqn{A_k} are \eqn{d \times d} matrices
and \eqn{X_t = 0} for \eqn{t \leq 0}.
}
\examples{
nbase = 10
Psi = t((1:nbase) \%*\% t(sin(1:nbase * 2*pi/nbase)) / (nbase*nbase))
process = rar(30, Psi=Psi, sd=0.2)
pdf(file='simulated.arh1.pdf')
plot(process)
title("Simulated ARH(1)")
dev.off()
}

