% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-adminlte.R
\name{adminlte_color}
\alias{adminlte_color}
\title{AdminLTE CSS colors variables}
\usage{
adminlte_color(light_blue = NULL, red = NULL, green = NULL,
  aqua = NULL, yellow = NULL, blue = NULL, navy = NULL,
  teal = NULL, olive = NULL, lime = NULL, orange = NULL,
  fuchsia = NULL, purple = NULL, maroon = NULL, black = NULL,
  gray_lte = NULL)
}
\arguments{
\item{light_blue}{Light blue (primary status), default to \code{#3c8dbc}.}

\item{red}{Red (danger status), default to \code{#dd4b39}.}

\item{green}{Green (success status), default to \code{#00a65a}.}

\item{aqua}{Aqua (info status), default to \code{#00c0ef}.}

\item{yellow}{Yellow (warning status), default to \code{#f39c12}.}

\item{blue}{Blue, default to \code{#0073b7}.}

\item{navy}{Navy, default to \code{#001F3F}.}

\item{teal}{Teal, default to \code{#39CCCC}.}

\item{olive}{Olive, default to \code{#3D9970}.}

\item{lime}{Lime, default to \code{#01FF70}.}

\item{orange}{Orange, default to \code{#FF851B}.}

\item{fuchsia}{Fuchsia, default to \code{#F012BE}.}

\item{purple}{Purple, default to \code{#605ca8}.}

\item{maroon}{Maroon, default to \code{#D81B60}.}

\item{black}{Black, default to \code{#111}.}

\item{gray_lte}{Gray, default to \code{#d2d6de}.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 defaults colors in {shinydashboard}.
}
\examples{

adminlte_color(
  light_blue = "#086A87",
  aqua = "#A9D0F5",
  green = "#0B3B0B",
  purple = "#610B4B"
)

if (interactive()) {
  library(shiny)
  library(shinydashboard)

  ui <- dashboardPage(
    header = dashboardHeader(title = "My dashboard"),
    sidebar = dashboardSidebar(
      sidebarMenu(
        menuItem("Dashboard", tabName = "dashboard", icon = icon("dashboard"))
      )
    ),
    body = dashboardBody(

      use_theme(create_theme(
        adminlte_color(
          light_blue = "#086A87",
          aqua = "#A9D0F5",
          green = "#0B3B0B",
          purple = "#610B4B"
        )
      )),

      tabItems(
        tabItem(
          "dashboard",

          # infoBoxes
          fluidRow(
            infoBox(
              "Orders", uiOutput("orderNum2"), "Subtitle", icon = icon("credit-card")
            ),
            infoBox(
              "Approval Rating", "60\%", icon = icon("line-chart"), color = "green",
              fill = TRUE
            ),
            infoBox(
              "Progress", "20\%", icon = icon("users"), color = "purple"
            )
          ),

          # valueBoxes
          fluidRow(
            valueBox(
              5846, "New Orders", icon = icon("credit-card"),
              href = "http://google.com"
            ),
            valueBox(
              tagList("60", tags$sup(style="font-size: 20px", "\%")),
              "Approval Rating", icon = icon("line-chart"), color = "green"
            ),
            valueBox(
              "42\%", "Progress", icon = icon("users"), color = "purple"
            )

          )
        )
      )
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
