% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{csv2csv}
\alias{csv2csv}
\title{Convert a German Comma Separated File into a Comma Separated File}
\usage{
csv2csv(file, ...)
}
\arguments{
\item{file}{Path to the file.}

\item{...}{Arguments passed to \code{\link{read_csv}}}
}
\value{
\code{\link[base:invisible]{Invisibly}} the return value of
\code{\link{write_csv}}, but called for its side effect.
}
\description{
Convert a German Comma Separated File into a Comma Separated File
}
\examples{
f <- tempfile()
write.csv2(mtcars, file = f)
res <- csv2csv(f)
readLines(get_path(res), n = 1)
write.csv(mtcars, file = f)
readLines(get_path(res), n = 1)
}
\seealso{
Other CSV functions.: 
\code{\link{bulk_read_csv}()},
\code{\link{bulk_write_csv}()},
\code{\link{csv}}
}
\concept{CSV functions.}
