% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{bulk_read_csv}
\alias{bulk_read_csv}
\title{Bulk Read Comma Separated Files}
\usage{
bulk_read_csv(paths, pattern = ".*\\\\.csv$", is_latin1 = TRUE, ...)
}
\arguments{
\item{paths}{A vector of file paths or the directory to find files.}

\item{pattern}{The pattern to identify comma separated files with.
Ignored, if \code{paths} is not a directory.}

\item{is_latin1}{Are the files encoded in "Latin1"?}

\item{...}{Arguments passed to \code{\link{find_files}}.
Ignored, if \code{paths} is not a directory.}
}
\value{
A named list, each element holding the contents of one \command{csv}
file read by \code{\link{read_csv}}.
}
\description{
Import a bunch of comma separated files or
all comma separated files below a directory using
\code{\link{read_csv}}.
}
\examples{
unlink(dir(tempdir(), full.names = TRUE))
data(mtcars)
mt_german <- mtcars
rownames(mt_german)[1] <- "Mazda R\u00f64"
names(mt_german)[1] <- "mg\u00dc"
#\% read from directory
for (i in 1:10) {
    f <- file.path(tempdir(), paste0("f", i, ".csv"))
    write.csv(mtcars[1:5, TRUE], file = f)
    f <- file.path(tempdir(), paste0("f", i, "_german.csv"))
    write.csv2(mt_german[1:7, TRUE], file = f, fileEncoding = "Latin1")
}
bulk <- bulk_read_csv(tempdir())

#\% pass a path
f <- list.files(tempdir(), pattern = ".*\\\\.csv$", full.names = TRUE)[1]
bulk <- bulk_read_csv(f)

#\% pass multiple path
f <- list.files(tempdir(), pattern = ".*\\\\.csv$", full.names = TRUE)[2:4]
bulk <- bulk_read_csv(f)
}
\seealso{
Other CSV functions: 
\code{\link{bulk_write_csv}()},
\code{\link{csv2csv}()},
\code{\link{csv}}
}
\concept{CSV functions}
