% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{running_sum}
\alias{running_sum}
\alias{running_mean}
\title{Compute sums or means over a sliding window.}
\usage{
running_sum(v, window = NULL, wts = NULL, na_rm = FALSE,
  restart_period = 10000L, check_wts = FALSE)

running_mean(v, window = NULL, wts = NULL, na_rm = FALSE, min_df = 0L,
  restart_period = 10000L, check_wts = FALSE)
}
\arguments{
\item{v}{a vector.}

\item{window}{the window size. if given as finite integer or double, passed through.
If \code{NULL}, \code{NA_integer_}, \code{NA_real_} or \code{Inf} are given, equivalent
to an infinite window size. If negative, an error will be thrown.}

\item{wts}{an optional vector of weights. Weights are \sQuote{replication}
weights, meaning a value of 2 is shorthand for having two observations
with the corresponding \code{v} value. If \code{NULL}, corresponds to
equal unit weights, the default. Note that weights are typically only meaningfully defined
up to a multiplicative constant, meaning the units of weights are
immaterial, with the exception that methods which check for minimum df will,
in the weighted case, check against the sum of weights. For this reason,
weights less than 1 could cause \code{NA} to be returned unexpectedly due
to the minimum condition. When weights are \code{NA}, the same rules for checking \code{v}
are applied. That is, the observation will not contribute to the moment
if the weight is \code{NA} when \code{na_rm} is true. When there is no
checking, an \code{NA} value will cause the output to be \code{NA}.}

\item{na_rm}{whether to remove NA, false by default.}

\item{restart_period}{the recompute period. because subtraction of elements can cause
loss of precision, the computation of moments is restarted periodically based on 
this parameter. Larger values mean fewer restarts and faster, though potentially less 
accurate results. Unlike in the computation of even order moments, loss of precision
is unlikely to be disastrous, so the default value is rather large.}

\item{check_wts}{a boolean for whether the code shall check for negative
weights, and throw an error when they are found. Default false for speed.}

\item{min_df}{the minimum df to return a value, otherwise \code{NaN} is returned,
only for the means computation.
This can be used to prevent moments from being computed on too few observations.
Defaults to zero, meaning no restriction.}
}
\value{
A vector the same size as the input.
}
\description{
Compute the mean or sum over 
an infinite or finite sliding window, returning a vector the same size as the input.
}
\details{
Computes the mean or sum of the elements, using a Kahan's Compensated Summation Algorithm,
a numerically robust one-pass method.

Given the length \eqn{n} vector \eqn{x}, we output matrix \eqn{M} where
\eqn{M_{i,1}}{M_i,1} is the sum or mean 
of \eqn{x_{i-window+1},x_{i-window+2},...,x_{i}}{x_(i-window+1),x_(i-window+2),...,x_i}.
Barring \code{NA} or \code{NaN}, this is over a window of size \code{window}.
During the 'burn-in' phase, we take fewer elements. If fewer than \code{min_df} for
\code{running_mean}, returns \code{NA}.
}
\note{
The moment computations provided by fromo are 
numerically robust, but will often \emph{not} provide the
same results as the 'standard' implementations,
due to differences in roundoff. We make every attempt to balance
speed and robustness. User assumes all risk from using
the fromo package.
}
\examples{
x <- rnorm(1e5)
xs <- running_sum(x,10)
xm <- running_mean(x,100)

}
\references{
Terriberry, T. "Computing Higher-Order Moments Online."
\url{http://people.xiph.org/~tterribe/notes/homs.html}

J. Bennett, et. al., "Numerically Stable, Single-Pass, 
Parallel Statistics Algorithms," Proceedings of IEEE
International Conference on Cluster Computing, 2009.
\url{https://www.semanticscholar.org/paper/Numerically-stable-single-pass-parallel-statistics-Bennett-Grout/a83ed72a5ba86622d5eb6395299b46d51c901265}

Cook, J. D. "Accurately computing running variance."
\url{http://www.johndcook.com/standard_deviation.html}

Cook, J. D. "Comparing three methods of computing 
standard deviation."
\url{http://www.johndcook.com/blog/2008/09/26/comparing-three-methods-of-computing-standard-deviation}

Kahan, W. "Further remarks on reducing truncation errors,"
Communications of the ACM, 8 (1), 1965.
\url{https://doi.org/10.1145/363707.363723}

Wikipedia contributors "Kahan summation algorithm," 
Wikipedia, The Free Encyclopedia, 
\url{https://en.wikipedia.org/w/index.php?title=Kahan_summation_algorithm&oldid=777164752}
(accessed May 31, 2017).
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
