% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_centsums.R
\name{as.centsums}
\alias{as.centsums}
\alias{as.centsums.default}
\title{Coerce to a centsums object.}
\usage{
as.centsums(x, order=3, na.rm=TRUE)

\method{as.centsums}{default}(x, order = 3, na.rm = TRUE)
}
\arguments{
\item{x}{a numeric, array, or matrix.}

\item{order}{the order, defaulting to \code{length(sums)+1}.}

\item{na.rm}{whether to remove \code{NA}.}
}
\value{
A centsums object.
}
\description{
Convert data to a \code{centsums} object.
}
\details{
Computes the raw sums on data, and stuffs the results into a 
\code{centsums} object.
}
\note{
The moment computations provided by fromo are 
numerically robust, but will often \emph{not} provide the
same results as the 'standard' implementations,
due to differences in roundoff. We make every attempt to balance
speed and robustness. User assumes all risk from using
the fromo package.
}
\examples{
set.seed(123)
x <- rnorm(1000)
cs <- as.centsums(x, order=5)
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
