% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dewPoint.R
\name{calcDewPoint.A}
\alias{calcDewPoint.A}
\title{Calculates dew point from ambient temperature and relative humidity.}
\usage{
calcDewPoint.A(RH, temp)
}
\arguments{
\item{RH}{[in percentage] relative humidity, an integer or double value between 0 and 100.}

\item{temp}{[°C] environmental temperature, an integer or double value between -20 and 60 °C}
}
\value{
dew point value (double)
}
\description{
The following formula is used for dew point estimation:
$$ (RH/100 )^(1/8) * (110+temp) -110) $$
,where RH is relative humidity and temp is ambient temperature.
The formula was taken from this wikipedia page:
<https://es.wikipedia.org/wiki/Punto_de_roc%C3%ADo>
}
\examples{
library(frost)
temp <- 25
rh <- 54
calcDewPoint(rh,temp,mode="A")

}
