% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/russet.R
\name{russet}
\alias{russet}
\title{Estimation of the russet risk for apple and pear fruits}
\usage{
russet(climdata, fendata)
}
\arguments{
\item{climdata}{a dataframe with hourly temperature and RH
data. Required columns are Date, Year, Month, Day, DOY (julian day),
Hour and RH.}

\item{fendata}{a dataframe with julian day of occurrence of the full
bloom (F2) phenological stage.
Must contain the columns Year and Fday in that order.}
}
\value{
data frame with the number of hours with RH>75\%
between 12 and 30 DAFB (Russet_h) each year in the series.
}
\description{
This function assesses the risk of russet in apple and pear 
fruits by estimating the number of hours with relative 
humidity above 75\% in the critical period (between 12 
and 30 days after full bloom, DAFB). The function requires
hourly temperatures and humidity, if only daily data is 
available, the function hourly_RH can be used to estimate them.
}
\examples{

# Select the appropiate columns from the example dataset
# Dates_BT and rename column names to make the file compatible
# with the function
library(tidyverse)
library(lubridate)
Bloom <- Dates_BT \%>\%
   select(Year, sbloom) \%>\%
   rename(Fday=sbloom)
# Obtain estimated hourly RH from the example dataset Tudela_DW
RH_h <- hourly_RH(Tudela_DW, 42.13132)
# Estimate the number of russet-inducing days for each season
Russet_Risk <-russet(RH_h,Bloom)

}
\author{
Carlos Miranda, \email{carlos.miranda@unavarra.es}
}
