% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create}
\alias{create}
\alias{file_create}
\alias{dir_create}
\alias{link_create}
\title{Create files, directories, or links}
\usage{
file_create(path, mode = "u=rw,go=r")

dir_create(path, mode = "u=rwx,go=rx", recursive = TRUE)

link_create(path, new_path, symbolic = TRUE)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{mode}{If file/directory is created, what mode should it have?

Links do not have mode; they inherit the mode of the file they link to.}

\item{recursive}{should intermediate directories be created if they do not
exist?}

\item{new_path}{The path where the link should be created.}

\item{symbolic}{Boolean value determining if the link should be a symbolic
(the default) or hard link.}
}
\value{
The path to the created object (invisibly).
}
\description{
These functions ensure that \code{path} exists; if it already exists it will
be left unchanged. That means that compared to \code{\link[=file.create]{file.create()}},
\code{file_create()} will not truncate an existing file, and compared to
\code{\link[=dir.create]{dir.create()}}, \code{dir_create()} will silently ignore
existing directories.
}
\examples{
\dontshow{fs:::pkgdown_tmp(c("/tmp/filedd461e481b37", "/tmp/filedd46ff2c769"))}
x <- file_create(file_temp())
is_file(x)
# dir_create applied to the same path will fail
try(dir_create(x))

x <- dir_create(file_temp())
is_dir(x)
# file_create applied to the same path will fail
try(file_create(x))
}
