% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_volume.R
\name{vol.imagestack}
\alias{vol.imagestack}
\title{Turn volume into an ImageMagick image stack.}
\usage{
vol.imagestack(volume, axis = 1L, intensity_scale = 255)
}
\arguments{
\item{volume}{a 3D image volume. Can be numeric, or something that can be read directly by \code{\link[magick]{image_read}} in 2D matrices (slices along the axis), e.g., a 3D array of color strings. If a 2D matrix is passed, the resulting stack will contain a single image.}

\item{axis}{positive integer in range 1L..3L or an axis name, the axis to use.}

\item{intensity_scale}{integer, value by which to scale the intensities in the volume to the range `[0, 1]`. Only used for numeric volumes. Set to NULL for data that can be read directly by \code{\link[magick]{image_read}}, and to 1 for intensity data that requires no scaling. Defaults to 255, which is suitable for 8 bit image data.}
}
\value{
a vectorized ImageMagick image, containing one subimage per slice. This can be interpreted as an animation or whatever.
}
\description{
Create an image from each slice along the axis, then stack those into an ImageMagick image stack.
}
\seealso{
Other volume utility: 
\code{\link{vol.boundary.box}()},
\code{\link{vol.merge}()},
\code{\link{vol.overlay.colors.from.activation}()},
\code{\link{vol.planes}()},
\code{\link{vol.slice}()}
}
\concept{volume utility}
