% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{getIn}
\alias{getIn}
\title{Retrieve values from nested named lists}
\usage{
getIn(named_list, listkeys)
}
\arguments{
\item{named_list}{a named list}

\item{listkeys}{vector of character strings, the nested names of the lists}
}
\value{
the value at the path through the lists, or NULL if no such path exists
}
\description{
Retrieve values from nested named lists
}
\examples{
   data = list("regions"=list("frontal"=list("thickness"=2.3, "area"=2345)));
   getIn(data, c("regions", "frontal", "thickness"));       # 2.3
   getIn(data, c("regions", "frontal", "nosuchentry"));     # NULL
   getIn(data, c("regions", "nosuchregion", "thickness"));  # NULL

}
