% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph_atlas_agg.R
\name{spread.values.over.hemi}
\alias{spread.values.over.hemi}
\title{Spread the values in the region_value_list and return them for one hemisphere.}
\usage{
spread.values.over.hemi(
  subjects_dir,
  subject_id,
  hemi,
  atlas,
  region_value_list,
  value_for_unlisted_regions = NA
)
}
\arguments{
\item{subjects_dir, }{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id, }{string. The subject identifier}

\item{hemi, }{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the annotation and morphometry data files to be loaded.}

\item{atlas, }{string. The atlas name. E.g., "aparc", "aparc.2009s", or "aparc.DKTatlas". Used to construct the name of the annotation file to be loaded.}

\item{region_value_list, }{named list. A list in which the names are atlas regions, and the values are the value to write to all vertices of that region. You can pass an unnamed list or vector, but then the length must exactly match the number of regions in the atlas, and the order must match the annotation file of the subject and hemisphere. Use with care, and keep in mind that some subjects do not have all regions.}

\item{value_for_unlisted_regions, }{numeric scalar. The value to assign to vertices which are part of atlas regions that are not listed in region_value_list. Defaults to NaN.}
}
\value{
numeric vector containing the data.
}
\description{
Given an atlas and a list that contains one value for each atlas region, create morphometry data in which all region vertices are assigned the value. Can be used to plot stuff like p-values or effect sizes onto brain regions.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   region_value_list = list("bankssts"=0.9, "precuneus"=0.7);
   morph_like_data =
   spread.values.over.hemi(subjects_dir, 'subject1', 'lh', 'aparc', region_value_list);
}

}
\seealso{
Other atlas functions: 
\code{\link{get.atlas.region.names}()},
\code{\link{group.agg.atlas.native}()},
\code{\link{group.agg.atlas.standard}()},
\code{\link{group.annot}()},
\code{\link{group.label.from.annot}()},
\code{\link{label.from.annotdata}()},
\code{\link{label.to.annot}()},
\code{\link{regions.to.ignore}()},
\code{\link{spread.values.over.annot}()},
\code{\link{spread.values.over.subject}()},
\code{\link{subject.annot}()},
\code{\link{subject.atlas.agg}()},
\code{\link{subject.label.from.annot}()},
\code{\link{subject.lobes}()}
}
\concept{atlas functions}
