% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_volume.R
\name{vol.overlay.colors.from.colortable}
\alias{vol.overlay.colors.from.colortable}
\title{Compute voxel colors based on colortable.}
\usage{
vol.overlay.colors.from.colortable(
  volume,
  colortable,
  ignored_struct_indices = c(),
  ignored_struct_names = c("unknown", "Unknown")
)
}
\arguments{
\item{volume}{numeric 3D array, the values should be integers present in the `struct_index` column of the colortable. All other values will be assigned `NA` as a color.}

\item{colortable}{a colortable, as returned by \code{\link[freesurferformats]{read.fs.colortable}}.}

\item{ignored_struct_indices}{integer vector, `struct_index` entries in the colortable that should be ignored}

\item{ignored_struct_names}{vector of character strings, `struct_name` entries in the colortable that should be ignored. Can be combined with `ignored_struct_indices`.}
}
\value{
character string 3D array, the colors. Voxels in the volume which were not matched by the colortable are set to `NA` in it.
}
\description{
Use the intensity values of the voxels in volume and lookup the respective colors in a colortable.
}
