% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_geom_set_operations.R
\name{spa_flatten}
\alias{spa_flatten}
\title{Flatten a plateau collection object}
\usage{
spa_flatten(pcol)
}
\arguments{
\item{pcol}{A \code{pcollection} object.}
}
\value{
A \code{pcollection} object consisting of a quadruple (\code{PLATEAUPOINT}, \code{PLATEAULINE}, \code{PLATEAUREGION}, \code{PLATEAUCOMPOSITION}).
}
\description{
\code{spa_flatten()} gathers all the objects of a plateau collection object and
reorganizes them into a single flattened spatial plateau object containing a quadruple
(\code{PLATEAUPOINT}, \code{PLATEAULINE}, \code{PLATEAUREGION}, \code{PLATEAUCOMPOSITION}) that preserves the identity of sub-objects.
}
\details{
The \code{spa_flatten()} function yields a single flattened spatial plateau object, aggregating all spatial plateau objects by their types.
In the case of a two-level hierarchy, i.e., a plateau collection inside another one,
the function is applied recursively in the lower levels until the quadruple is built. Hence, it simplifies the representation of complex plateau collection objects.
The t-conorm considered in the aggregation is the \code{max} operator.
}
\examples{
# Point components
pcp1 <- create_component("POINT(0 0)", 0.3)
pcp2 <- create_component("MULTIPOINT((2 2), (2 4), (2 0))", 0.5)
pcp3 <- create_component("MULTIPOINT((1 1), (3 1), (1 3), (3 3))", 0.9)
pcp4 <- create_component("MULTIPOINT((10 10), (9 8), (7 7))", 1)
pcp5 <- create_component("MULTIPOINT((0 0), (2 3))", 0.7)
pcp6 <- create_component("MULTIPOINT((0 1), (3 3))", 0.85)
pcp7 <- create_component("MULTIPOINT((1 0), (2 3))", 0.4)
# Line components
lcp1 <- create_component("LINESTRING(0 0, 1 1.5)", 0.2)
lcp2 <- create_component("LINESTRING(1 3, 1 2, 2 0.5)", 0.5)
lcp3 <- create_component("LINESTRING(2 1.2, 3 1.6, 4 4)", 0.7)
lcp4 <- create_component("LINESTRING(1 1.5, 2 1.2)", 1.0)
lcp5 <- create_component("LINESTRING(-1 1, 2 2)", 0.9)
# Polygon components
rcp1 <- create_component("POLYGON((0 0, 1 4, 2 2, 0 0))", 0.4)
rcp2 <- create_component("POLYGON((2 0.5, 4 1, 4 0, 2 0.5))", 0.8)

# Creating plateau point objects
ppoint1 <- create_pgeometry(list(pcp1, pcp2, pcp3), "PLATEAUPOINT")
ppoint2 <- create_pgeometry(list(pcp4, pcp5), "PLATEAUPOINT")
ppoint3 <- create_pgeometry(list(pcp4, pcp5), "PLATEAUPOINT")
ppoint4 <- create_pgeometry(list(pcp6, pcp7), "PLATEAUPOINT")
# Creating plateau line objects
pline1 <- create_pgeometry(list(lcp1, lcp3), "PLATEAULINE")
pline2 <- create_pgeometry(list(lcp2, lcp4), "PLATEAULINE")
pline3 <- create_pgeometry(list(lcp5), "PLATEAULINE")
# Creating a plateau region objects
pregion <- create_pgeometry(list(rcp1, rcp2), "PLATEAUREGION")
# Creating a plateau composition object
pcomposition <- create_pgeometry(list(ppoint4, pline3), "PLATEAUCOMPOSITION")
# Creating plateau collection objects
pcol1 <- create_pgeometry(list(ppoint1, ppoint2, ppoint3, pline1), "PLATEAUCOLLECTION")
pcol2 <- create_pgeometry(list(pline2, pregion, pcomposition, pcol1), "PLATEAUCOLLECTION")
\dontrun{
pcol2
plot(pcol2)

flatten_col <- spa_flatten(pcol2)
flatten_col
plot(flatten_col)
}
}
\references{
\href{https://ieeexplore.ieee.org/document/9177620}{Carniel, A. C.; Schneider, M. Spatial Data Types for Heterogeneously Structured Fuzzy Spatial Collections and Compositions. In Proceedings of the 2020 IEEE International Conference on Fuzzy Systems (FUZZ-IEEE 2020), pp. 1-8, 2020.}
}
