% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-paragraph-md.R
\name{as_paragraph_md}
\alias{as_paragraph_md}
\title{Convert a character vector into markdown paragraph(s)}
\usage{
as_paragraph_md(
  x,
  auto_color_link = "blue",
  .from = "markdown+autolink_bare_uris"
)
}
\arguments{
\item{x}{A character vector.}

\item{auto_color_link}{A color of the link texts.}

\item{.from}{Pandoc's \code{--from} argument (default: \code{'markdown+autolink_bare_uris'}).}
}
\description{
Parse markdown cells and returns the "paragraph" object.
}
\examples{
library(flextable)
ft <- flextable(
  data.frame(
    x = c("**foo** bar", "***baz***", "*qux*"),
    stringsAsFactors = FALSE
  )
)
ft <- compose(ft, j = "x", i = 1:2, value = as_paragraph_md(x))
autofit(ft)
}
